/**
 *
 * \file        hprfgw_rftrans.h
 *
 * \brief       The RF transmit function header file.		
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        08/29/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFTRANS_H_
	#define _HPRFGW_RFTRANS_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfDesc.h"
#include "hprfgw_rfComLog.h"
#include "hprfgw_rfNwkMacInterface.h"
#include "hprfgw_rfAppAspInterface.h"
#include "hprfgw_rfPublicConst.h"

#ifdef  __cplusplus
extern "C" 
{
#endif


////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////

//	RF packet priorities
#define	RF_PACKET_PRIORITY_LOW						0
//	other priorities
//#define	.....
#define	RF_PACKET_PRIORITY_HIGH						255

//	Security options
//#define	RF_TRANS_SECURITY_ENABLE				1
//#define	RF_TRANS_SECURITY_ACL					1
//#define	RF_TRANS_SECURITY_SEQUENTIAL_FRESHNESS	2
//#define	RF_TRANS_SECURITY_DES					3
//#define	RF_TRANS_SECURITY_TYPE					RF_TRANS_SECURITY_DES			

//#define	RF_DEVICE_PIPE_MSG_LEN					255

#define	RF_DEVICE_LINK_QUALITY_HYSTERISES			655		//	rf device link quality hysterisas threshold

//	Packet types exchange between rf transmit task 
enum	{
	RF_PACKET_TYPE_MCP_REQUEST=1,
	RF_PACKET_TYPE_MLM_REQUEST,
	RF_PACKET_TYPE_ASP_REQUEST,
	RF_PACKET_TYPE_PROC_REQUEST,

	RF_PACKET_TYPE_MCP_REPLY=10,
	RF_PACKET_TYPE_MLM_REPLY,
	RF_PACKET_TYPE_ASP_REPLY,
	RF_PACKET_TYPE_PROC_REPLY
};	

//	Internal RF transmit packet header 
//		BYTE1 = FREESCALE Message Type MCP,MLM or ASP
//		BYTE2 =	PACKET Type
//		BYTE3 = Options1
//		BYTE4 = Options2
//		BYTE5 = Options3		
//	RF Device frame header option1 flags definitions
#define	RF_DEVICE_HEADER_OPTION1_BROADCAST			1		//	Broadcast frame (broadcasted frame will never req ack even if the ack_req bit is set) 
#define	RF_DEVICE_HEADER_OPTION1_REQ_ACK			2		//	Request the acknowledge frame (1/0=req ack/do not req ack)	
#define RF_DEVICE_HEADER_OPTION1_BROADCAST_RPT		4		//	Repeat broadcast packet	(same sequence no sent)	
#define RF_DEVICE_HEADER_OPTION1_DONOT_CONCATE		8		//	Do not concate 
//#define RF_DEVICE_HEADER_OPTION1_					16		//	unused
#define	RF_DEVICE_HEADER_OPTION1_PRIORITY_HIGH		32		//	Frame priority bit (0/1=low priority/high priority) 
//#define RF_DEVICE_HEADER_OPTION1_					64		//	unused	(for future expansion of frame priority) 
//#define RF_DEVICE_HEADER_OPTION1_					128		//	unused	(for future expansion of frame priority) 			

//	RF Device frame header option2 flags definitions
//#define	RF_DEVICE_HEADER_OPTION2_				1		//	unused	 
//#define	RF_DEVICE_HEADER_OPTION2_       		2		//	unused	
//#define	RF_DEVICE_HEADER_OPTION2_        		4		//	unused
//#define	RF_DEVICE_HEADER_OPTION2_         		8		//	unused
//#define	RF_DEVICE_HEADER_OPTION2_               16		//	unused
//#define	RF_DEVICE_HEADER_OPTION2_               32		//	unused 
//#define	RF_DEVICE_HEADER_OPTION2_				64		//	unused	 
//#define	RF_DEVICE_HEADER_OPTION2_				128		//	unused	 			

#define RFTRANS_ACTIVE_SCAN_DURATION				3			//	3-sec for 16 channels (Equ:   T[sec] = (16*960*((2^dc)+1))/1000000)
#define	RFTRANS_ENERGY_SCAN_DURATION				5			//	8-sec for 16 channels (Equ:   T[sec] = (16*960*((2^dc)+1))/1000000)
#define	RFTRANS_SCAN_ALL_CHANNEL_MASK				0x07FFF800	//	Channels 11..26			

////////////////////////////////////////////////////////////////////////////////
//	Data Prototypes	
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////

extern	void	RFTransmit_Init (void);
extern	void	RFTransmit_TriggerRFTransmitTaskEvent (UINT8 index);
extern	void	RFTransmit_RFStackBufferAvailableEvent (void);		
extern	UINT16	RFTransmit_BuildLinkRequestPacketAndPostToPipeByIndex (UINT8 index, UINT8 flags, UINT8 linkcondition, UINT8 deviceoptions, UINT16 randomno, INT8 *pIDStr, BOOL Broadcast, UINT8 repeats);
extern	UINT16  RFTransmit_BuildLinkReplyPacketAndPostToPipeByIndex (UINT8 index, UINT8 ResultCode, UINT16 RandomNo, INT8* pGatewayName);
extern	UINT16 	RFTransmit_BuildCommunicationErrorPacketAndPostToPipeByIndex (UINT8 index, UINT16 Flags, UINT8 ExpectedSequenceNo, UINT8 ReceivedSequenceNo, UINT8 TotalSegments, UINT8 ExpectedSegment, UINT8 ReceivedSegment);
extern	UINT16 	RFTransmit_BuildBufferOverflowPacketAndPostToPipeByIndex (UINT8 index, UINT8 TxpipeOverFlow, UINT8 RxpipeOverFlow);
extern	UINT16  RFTransmit_BuildCresnetPacketAndPostToPipeByRFID (UINT8 rfid, UINT8 *pbuf, UINT16 len, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
extern	UINT16	RFTransmit_BuildCresnetPacketAndPostToPipeByIndex (UINT8 index, UINT8 *pbuf, UINT16 len, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
extern	UINT16	RFTransmit_BuildLocalCresnetPacketAndPostToPipeByIndex (UINT8 index, UINT8 *pbuf, UINT16 len, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
extern	UINT16  RFTransmit_BuildLocalCresnetPacketAndPostToPipeByRFID (UINT8 rfid, UINT8 *pbuf, UINT16 len, UINT8 priority, INT32(*pcbf)(UINT32 par, UINT32 status), UINT32 cbfpar, UINT32 timetolive);
extern	UINT16	RFTransmit_BuildChannelSelectionFrameAndPostToPipe (UINT8 channel);
extern	UINT16	RFTransmit_BuildPowerLevelFrameAndPostToPipe (UINT16 power, BOOL Translate);
extern	UINT16	RFTransmit_BuildAssociateRequestMessageAndPostToPipe (UINT8 *puid, UINT16 panid);
extern	UINT16	RFTransmit_BuildDisAssociateRequestMessageAndPostToPipe (UINT8 *puid, UINT8 reason);
extern	UINT16  RFTransmit_BuildAssociateResponseMessageAndPostToPipe(UINT8 *puid);
extern	UINT16	RFTransmit_BuildEchoRequestPacketAndPostToPipeByRFID (UINT8 rfid, UINT8 *pBuf, UINT8 Len);
extern  UINT16  RFTransmit_BuildEchoRequestPacketAndPostToPipeByIndex (UINT8 index, UINT8 *pBuf, UINT8 Len);
extern	UINT16	RFTransmit_BuildEchoReplyPacketAndPostToPipeByIndex (UINT8 index, UINT8 *pBuf, UINT8 Len);
extern	UINT16	RFTransmit_BuildSleepModePacketAndPostToPipeByIndex (UINT8 index);	
extern	UINT16	RFTransmit_BuildPowerDownModePacketAndPostToPipeByIndex (UINT8 index);
extern	UINT16	RFTransmit_BuildIDStringPacketAndPostToPipeByIndex (UINT8 index, UINT8 rfid, UINT32 tsid, UINT8 *pIDStr);
extern  UINT16	RFTransmit_BuildHeartBeatPacketAndPostToPipeByIndex(UINT8 index);
extern  UINT16	RFTransmit_BuildAppScanPacketAndPostToPipe (UINT8 scanType, UINT8 scanDuration, UINT32 ChannelMask);
extern	UINT16	RFTransmit_BuildPromiscuousMessageAndPostToPipe (BOOL Enable);
extern	UINT16	RFTransmit_BuildResetMACMessageAndPostToPipe (BOOL SetToDefault);
extern	UINT16	RFTransmit_BuildTELCTestMessageAndPostToPipe (UINT8 mode);
extern	UINT16	RFTransmit_BuildTELCTestChannelMessageAndPostToPipe (UINT8 channel);
extern	UINT16	RFTransmit_BuildGetPIBAttributeMessageAndPostToPipe (UINT8 Attribute, TYPE_RFSTACK_CB *pcb);
extern	UINT16	RFTransmit_ReadPIBAttributeValue(UINT8 Attribute, UINT8 *pbuf, UINT8 *plen);
extern  UINT16	RFTransmit_BuildUIDMessageAndPostToPipe (UINT8 *pNewUID);
extern  UINT16	RFTransmit_BuildPANIDMessageAndPostToPipe (UINT16 NewPANID);
extern  UINT16	RFTransmit_BuildShortAddrMessageAndPostToPipe (UINT16 ShortAddr);
extern	UINT16	RFTransmit_BuildSettoIdleFrameAndPostToPipe (UINT8 enable);
extern	UINT16  RFTransmit_BuildCSStatusPacketAndPostToPipeByRFID (UINT8 rfid);
extern  UINT16  RFTransmit_BuildBufferOverflowPacketAndPostToPipeByRFID (UINT8 rfid, UINT8 TxpipeOverFlow, UINT8 RxpipeOverFlow);
extern	UINT16  RFTransmit_BuildGatewayReStartPacketAndPostToPipeByIndex (UINT8 index, BOOL Broadcast, UINT32 flags, UINT8 repeats);
extern	UINT16	RFTransmit_ResetTxBuffers (UINT8 index);
extern	UINT16	RFTransmit_MCPPacketResultCodeCallBack (UINT8 index);
extern  UINT16	RFTransmit_MCPPacketTimeToLiveExpirationChk (UINT8 index, BOOL *allpktsexpired);
extern  UINT16	RFTransmit_ResetTxBuffers (UINT8 index);
extern	UINT16	RFTransmit_ResetTxDataHoldBuffer (UINT8 index);
extern	UINT16  RFTransmit_BuildThroughPutPacketAndPostToPipeByIndex (UINT8 index, UINT8 *pbuf, UINT16 len, TYPE_RFSTACK_CB *pcb, UINT8 Broadcast, UINT8 nocat);
extern	UINT32	RFTransmit_GetPipeAvailableMemorySizeByIndex (UINT8 index, UNSIGNED *ppipesize, UNSIGNED *pavaliable, UNSIGNED *pmessages);
extern	UINT16	RFTransmit_BuildDeviceFieldDataRequestPacketAndPostToPipeByIndex (UINT8 index, UINT8 Field);
extern	UINT16	RFTransmit_BuildDeviceFieldDataReplyPacketAndPostToPipeByIndex (UINT8 index, UINT8 Field, UINT16 crc, UINT8 *pBuf, UINT8 BufLen);
extern	UINT16  RFTransmit_BuildRFNetDiscoverRequestPacketAndPostToPipeByIndex (UINT8 index, UINT32 flags, BOOL broadcast, UINT8 repeats);
extern	UINT16	RFTransmit_BuildRFNetDiscoverReplyPacketAndPostToPipeByIndex (UINT8 index, UINT32 flags);
extern	void	RFTransmit_ReTriggerLowPriorityMessagePostDelay (void);
extern	UINT16  RFTransmit_BuildRFNetRemoteSetupPacketAndPostToPipeByIndex (UINT8 index, UINT32 flags, UINT8 *pdevuid, UINT16 devpanid, UINT8 devaddrmode, UINT8 *pgwuid, UINT16 gwpanid, UINT8 gwaddrmode);	
extern	INT32	RFTransmit_CheckifMessagehastimetolive (UINT32 start, UINT32 timetolive);
extern  UINT16  RFTransmit_BuildRFNetDiscoverBeaconPacketAndPostToPipeByIndex (UINT8 index, UINT32 flags, BOOL broadcast, BOOL DonotConcate, TYPE_RFSTACK_CB *pcb);
#ifdef	RF_NETWORK_MASTER_DEVICE
 extern	UINT16	RFTransmit_BuildRFNetBeaconReplyPacketAndPostToPipeByIndex (UINT8 index, UINT32 flags);
#else
 extern	UINT16  RFTransmit_BuildRFBeaconReqPacketAndPostToPipeByIndex (UINT8 index, UINT32 flags, BOOL broadcast);
#endif

#ifdef  __cplusplus
}
#endif



#endif
/**/

